import Random

---- Juego de dados ----

m :: Int
m = 3
type Contador = [Int]
contadorInicial :: Contador
contadorInicial = take (2*m+1) (copy 0)
   where copy a = a:copy a


type Posicion = Int
incrementa :: Posicion -> Contador -> Contador

incrementa 0     (c:cs) = (c+1):cs
incrementa (n+1) (c:cs) = c:incrementa n cs

dados:: Int -> [Int]
dados sem  = map (\y -> ((m+1) * y) `div` 1023) (alea sem)

alea sem = iterate (\x -> (77*x+1) `rem` 1024) sem



type NumeroDeTiradas = Int
type Semilla = Int
simula :: NumeroDeTiradas  -> Semilla  -> Contador

simula n sem = tira n contadorInicial (dados sem)

tira 0 con _ = con
tira (n+1) con (d:d':ds) = tira n (incrementa (d+d') con) ds


frec :: Fractional a => Int -> a
frec v |  v< m      = fromIntegral (v+1) / fromIntegral ((m+1)^2)
        |  otherwise = fromIntegral (2*m-v+1)/ fromIntegral ((m+1)^2)

estudioEstadstico :: NumeroDeTiradas -> Semilla -> (Contador,[Double])
estudioEstadstico sem n = (simula n sem, 
   [ (realToFrac n) * frec v |v<-[0..2*m] ] )

-- otra posibilidad es devolver el siguiente tipo

frec2 :: Int -> Ratio Integer
frec2 v |  v< m       = toRational (v+1)/ toRational ((m+1)^2)
       |  otherwise = toRational (2*m-v+1)/ toRational ((m+1)^2)

estudioEstadstico2 :: NumeroDeTiradas -> Semilla -> (Contador,[Ratio Integer])
estudioEstadstico2 sem n = (simula n sem, [ toRational n * frec2 v | v<-[0..2*m] ] )

simulaIO :: NumeroDeTiradas  -> IO ()
simulaIO n = getStdRandom (randomR (1,1024)) >>= \sem -> 
                            print (show (estudioEstadstico sem n))
